# -*- coding: utf-8 -*-

msfs_mode = 1
icao = "haab"


@AlternativeStopPositions
def S2(aircraftData):
    
  TableIcao = {
    "B38M": -5.9,
    "A319": 0,
    "A321": 0,
    "B77W": 1,
  }
  return Distance.fromMeters(TableIcao.get(aircraftData.icaoTypeDesignator, 0) )

@AlternativeStopPositions
def Nbig(aircraftData):
    
  TableIcao = {
    "B38M": -4.6,
    "B77W": 11,
    "A359": 11,
    "A35K": 11,
    "A339": 6.75,
	"A332": 6.75,
	"A333": 6.75,
	"B739": -4.6,
	"B738": -4.6,
	"B737": -4.6,
	"A320": -4.5,
	"A321": -4.5,
	"A319": -4.5,
	"A20N": -4.5,
	"A21N": -4.5,		

  }
  return Distance.fromMeters(TableIcao.get(aircraftData.icaoTypeDesignator, 0) )

@AlternativeStopPositions
def Nbig2(aircraftData):
    
  TableIcao = {
    "B38M": 1.7,
    "A319": 0,
    "A321": 0,
    "B77W": 1,
  }
  return Distance.fromMeters(TableIcao.get(aircraftData.icaoTypeDesignator, 0) )

@AlternativeStopPositions
def Nbig15(aircraftData):
    
  TableIcao = {
    "B38M": 1.7,
    "A319": 0,
    "A321": 0,
    "B77W": 20,
    "A359": 15,
    "A35K": 15,	
	"A339": 11,
	"A332": 11,
	"A333": 11,
	"B739": 1.7,
	"B738": 1.7,
	"B737": 1.7,
	"A320": 1.7,
	"A321": 1.7,
	"A319": 1.7,
	"A20N": 1.7,
	"A21N": 1.7,	
  }
  return Distance.fromMeters(TableIcao.get(aircraftData.icaoTypeDesignator, 0) )

@AlternativeStopPositions
def Nbig11(aircraftData):
    
  TableIcao = {
    "B38M": 0.2,
    "A319": 0,
    "A321": 0,
    "B77W": 22,
    "A359": 17,
    "A35K": 17,	
	"A332": 11.5,
	"A333": 11.5,
	"A339": 11.5,
    "B739": 0.2,
	"B738": 0.2,
	"B737": 0.2,
	"A320": 0.2,
	"A321": 0.2,
	"A319": 0.2,
	"A20N": 0.2,
	"A21N": 0.2,	
  }
  return Distance.fromMeters(TableIcao.get(aircraftData.icaoTypeDesignator, 0) )

@AlternativeStopPositions
def Nbig3(aircraftData):
    
  TableIcao = {
    "B38M": -2.9,
    "A319": 0,
    "A321": 0,
    "B77W": 11,
    "A359": 11,
    "A35K": 11,
	"A339": 7.75,	
	"A332": 7.75,
	"A333": 7.75,
	"B739": -2.9,
	"B738": -2.9,
	"B737": -2.9,
	"A320": -2.9,
	"A321": -2.9,
	"A319": -2.9,
	"A20N": -2.9,
	"A21N": -2.9,	
  }
  return Distance.fromMeters(TableIcao.get(aircraftData.icaoTypeDesignator, 0) )

@AlternativeStopPositions
def Nbig10(aircraftData):
    
  TableIcao = {
    "B38M": -5.2,
    "A319": 0,
    "A321": 0,
    "B77W": 11,
    "A359": 11,
    "A35K": 11,	
	"A339": 11,
"A332": 11.5,
	"A333": 11,
	"A339": 11,
    "B739": -5.2,
	"B738": -5.2,
	"B737": -5.2,
	"A320": -5.5,
	"A321": -5.5,
	"A319": -5.5,
	"A20N": -5.5,
	"A21N": -5.5,	

  }
  return Distance.fromMeters(TableIcao.get(aircraftData.icaoTypeDesignator, 0) )

@AlternativeStopPositions
def Nmed1(aircraftData):
    
  TableIcao = {
    "B38M": -5.6,
    "A319": 0,
    "A321": 0,
    "B77W": 1,
    "A359": 0.75,
    "A35K": 0.75,
	"A339": 0.75,
"A332": 0.75,
	"A333": 0.75,
	"A339": 0.75,
    "B739": -5.6,
	"B738": -5.6,
	"B737": -5.6,
	"A320": -5.5,
	"A321": -5.5,
	"A319": -5.5,
	"A20N": -5.5,
	"A21N": -5.5,	
	
  }
  return Distance.fromMeters(TableIcao.get(aircraftData.icaoTypeDesignator, 0) )

@AlternativeStopPositions
def Nmed2(aircraftData):
    
  TableIcao = {
    "B38M": -0.1,
    "A319": 0,
    "A321": 0,
    
  }
  return Distance.fromMeters(TableIcao.get(aircraftData.icaoTypeDesignator, 0) )

@AlternativeStopPositions
def Nmed3(aircraftData):
   
  TableIcao = {
    "B38M": -2.5,
    "A319": 0,
    "A321": 0,
 "B739": -2.5,
	"B738": -2.5,
	"B737": -2.5,
	"A320": -5.5,
	"A321": -2.5,
	"A319": -2.5,
	"A20N": -2.5,
	"A21N": -2.5,	
	
    
  }
  return Distance.fromMeters(TableIcao.get(aircraftData.icaoTypeDesignator, 0) )

@AlternativeStopPositions
def Sbig(aircraftData):
    
  TableIcao = {
    "B38M": -5.6,
    "A319": 0,
    "A321": 0,
    "B77W": 1,
    "A359": 0.75,
    "A35K": 0.75,
	"A332": -5.5,
	"A333": -5.5,
	"A339": -5.5,
    "B739": -5.67,
	"B738": -5.67,
	"B737": -5.67,
	"A320": -5.5,
	"A321": -5.5,
	"A319": -5.5,
	"A20N": -5.5,
	"A21N": -5.5,	
  }
  return Distance.fromMeters(TableIcao.get(aircraftData.icaoTypeDesignator, 0) )

@AlternativeStopPositions
def Cbig(aircraftData):
    
  TableIcao = {
    "B38M": -5.6,
    "A319": 0,
    "A321": 0,
    "B77W": 1,
    "A359": 0.75,
    "A35K": 0.75,
	"A339": 0.75,	
	
  }
  return Distance.fromMeters(TableIcao.get(aircraftData.icaoTypeDesignator, 0) )


parkings = {
	GATE_S : {
		None : (),
		1 : (CustomizedName("Gate S|S1") , Sbig),
		2 : (CustomizedName("Gate S|S2") , Sbig),
		3 : (CustomizedName("Gate S|S3") , Sbig),
		4 : (CustomizedName("Gate S|S4") , Sbig),
		5 : (CustomizedName("Gate S|S5") , Sbig),
		6 : (CustomizedName("Gate S|S6") , Sbig),
		7 : (CustomizedName("Gate S|S7") , Sbig),
		8 : (CustomizedName("Gate S|S8") , Sbig),
		9 : (CustomizedName("Gate S|S9") , Sbig),
		10 : (CustomizedName("Gate S|S10") , Sbig),
		11 : (CustomizedName("Gate S|S11") , Sbig),
		12 : (CustomizedName("Gate S|S12") , Sbig),
		13 : (CustomizedName("Gate S|S13") , Sbig),
		14 : (CustomizedName("Gate S|S14") , ),
		15 : (CustomizedName("Gate S|S15") , ),
		16 : (CustomizedName("Gate S|S16") , ),
		17 : (CustomizedName("Gate S|S17") , ),
		18 : (CustomizedName("Gate S|S18") , ),
		19 : (CustomizedName("Gate S|S19") , ),
		20 : (CustomizedName("Gate S|S20") , ),
		21 : (CustomizedName("Gate S|S21") , ),
		22 : (CustomizedName("Gate S|S22") , ),
		23 : (CustomizedName("Gate S|S23") , ),
		24 : (CustomizedName("Gate S|S24") , ),
		25 : (CustomizedName("Gate S|S25") , ),
		26 : (CustomizedName("Gate S|S26") , ),
		27 : (CustomizedName("Gate S|S27") , ),


		},
GATE_C : {
		None : (),
		1 : (CustomizedName("Cargo C|C1") , Cbig),
		2 : (CustomizedName("Cargo C|C2") , Cbig),
		3 : (CustomizedName("Cargo C|C3") , Cbig),
		4 : (CustomizedName("Cargo C|C4") , Cbig),
		5 : (CustomizedName("Cargo C|C5") , Cbig),
		6 : (CustomizedName("Cargo C|C6") , Cbig),
		7 : (CustomizedName("Cargo C|C7") , Cbig),
		8 : (CustomizedName("Cargo C|C8") , Cbig),
		9 : (CustomizedName("Cargo C|C9") , Cbig),
		10 : (CustomizedName("Cargo C|C10") , Cbig),
		11 : (CustomizedName("Cargo C|C11") , Cbig),
		12 : (CustomizedName("Cargo C|C12") , ),
		

		},

	GATE_N : {
		None : (),
		1 : (CustomizedName("Gate N|N1") , Nmed1),
		2 : (CustomizedName("Gate N|N2") , Nmed1),
		3 : (CustomizedName("Gate N|N3") , Nmed1),
		4 : (CustomizedName("Gate N|N4") , Nmed1),
		5 : (CustomizedName("Gate N|N5") , Nmed2),
		6 : (CustomizedName("Gate N|N6") , Nmed2),
		7 : (CustomizedName("Gate N|N7") , Nmed2),
		8 : (CustomizedName("Gate N|N8") , Nmed2),
		9 : (CustomizedName("Gate N|N9") , Nmed2),

		10 : (CustomizedName("Gate N|N10") , Nbig10),
		11 : (CustomizedName("Gate N|N11") , Nbig11),
		12 : (CustomizedName("Gate N|N12") , Nbig3),
		13 : (CustomizedName("Gate N|N13") , Nbig3),
		14 : (CustomizedName("Gate N|N14") , Nbig3),
		15 : (CustomizedName("Gate N|N15") , Nbig15),
		16 : (CustomizedName("Gate N|N16") , Nbig),
		17 : (CustomizedName("Gate N|N17") , Nbig),
		18 : (CustomizedName("Gate N|N18") , Nbig),
		19 : (CustomizedName("Gate N|N19") , Nbig),
		20 : (CustomizedName("Gate N|N20") , Nbig),
		21 : (CustomizedName("Gate N|N21") , Nbig),
		22 : (CustomizedName("Gate N|N22") , Nmed3),
		23 : (CustomizedName("Gate N|N23") , Nmed3),
		

		},

GATE_H : {
		None : (),
		1 : (CustomizedName("Gate H|H1") , Nmed3),
		2 : (CustomizedName("Gate H|H2") , Nmed3),
		3 : (CustomizedName("Gate H|H3") , Nmed3),
				
		},




}